#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Moving zigzag patternMod01.fsh   by   fra_michelini
//https://www.shadertoy.com/view/3t2BWW
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract
//start common//
// Simplex 2D noise
//
vec3 permute(vec3 x) { return mod(((x*34.0)+1.0)*x, 289.0); }

float snoise(vec2 v){
  const vec4 C = vec4(0.211324865405187, 0.366025403784439,
           -0.577350269189626, 0.024390243902439);
  vec2 i  = floor(v + dot(v, C.yy) );
  vec2 x0 = v -   i + dot(i, C.xx);
  vec2 i1;
  i1 = (x0.x > x0.y) ? vec2(1.0, 0.0) : vec2(0.0, 1.0);
  vec4 x12 = x0.xyxy + C.xxzz;
  x12.xy -= i1;
  i = mod(i, 289.0);
  vec3 p = permute( permute( i.y + vec3(0.0, i1.y, 1.0 ))
  + i.x + vec3(0.0, i1.x, 1.0 ));
  vec3 m = max(0.5 - vec3(dot(x0,x0), dot(x12.xy,x12.xy),
    dot(x12.zw,x12.zw)), 0.0);
  m = m*m ;
  m = m*m ;
  vec3 x = 2.0 * fract(p * C.www) - 1.0;
  vec3 h = abs(x) - 0.5;
  vec3 ox = floor(x + 0.5);
  vec3 a0 = x - ox;
  m *= 1.79284291400159 - 0.85373472095314 * ( a0*a0 + h*h );
  vec3 g;
  g.x  = a0.x  * x0.x  + h.x  * x0.y;
  g.yz = a0.yz * x12.xz + h.yz * x12.yw;
  return 130.0 * dot(m, g);
}
//end common//
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
  vec2 uv = fragCoord.xy / iResolution.xy;
  uv.x *= iResolution.x / iResolution.y;

  vec3 color = vec3(0.0);

  // sinewave on UV
  uv.y += sin(uv.x * 5.0 + iTime* 3.3) * 0.05 * cos(uv.x) * 0.3;

  // move UV over time
  uv.x += iTime * 0.09;
  uv.y += iTime * 0.04;

  // Make a grid
  vec2 gv = fract(uv*7.0);

  // Remap GV from [0..1] to [-1..1]
  gv.x = gv.x * 2.0 - 1.0;
  gv.x = abs(gv.x);

  // Distort uv.y
  gv.y += gv.x * 0.4;
  gv.y -= 0.1;
  
  // Define the colors of the bands
  vec3 col1 = vec3(0.3882, 0.102, 0.502);
  vec3 col2 = vec3(0.6588, 0.0784, 0.5137);
  vec3 col3 = vec3(1.0, 0.2, 0.7);
  
  // Adding the bands
  if (gv.y <= 0.19)
    color += col1 * (1.0 - smoothstep(0.0, 0.19, gv.y) * 0.5);

  if (gv.y > 0.19 && gv.y <= 0.53)
    color += col2 * (1.0 - smoothstep(0.34, 0.53, gv.y) * 0.5);

  if (gv.y > 0.53 && gv.y <= 0.86)
    color += col3 * (1.0 - smoothstep(0.67, 0.86, gv.y) * 0.5);

  if (gv.y > 0.86)
    color += col1 * (1.0 - smoothstep(1.0, 1.19, gv.y) * 0.5);

  if (gv.y > 1.19 && gv.y <= 1.53)
    color = col2 * (1.0 - smoothstep(1.34, 1.53, gv.y) * 0.5);
    
  float noise = snoise(uv*3.3 - vec2(iTime*0.7, iTime*1.4)) * 0.5 + 0.5;
  
  // Playing around with color values
  color.rg -= gv.x*0.3;
  color.rg -= min(0.35, max(0.6, gv.x)) * 1.2;
  color.r = pow(color.r, 4.5 * noise);
  color.g = pow(color.r, 9.5 * noise);
  color.b = pow(color.b, 2.5 * noise);

  fragColor = vec4(color, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

